//Full counter propagation network for given input pair
//Windows 10
//Scilab 5.4.1
clear;
clc;

//set initial weights
 v=[0.6 0.2;0.6 0.2;0.2 0.6; 0.2 0.6];
 w=[0.4 0.3;0.4 0.3];
 x=[0 1 1 0];
 y=[1 0];
 alpha=0.3;
 for j=1:2
     D(j)=0;
     for i=1:4
         D(j)=D(j)+(x(i)-v(i,j))^2;
     end
     for k=1:2
        D(j)=D(j)+(y(k)-w(k,j))^2;
     end
 end
 for j=1:2
     if D(j)==min(D)
         J=j;
     end
 end
 disp('After one step the weight matrix are'); 
 v(:,J)=v(:,J)+alpha*(x'-v(:,J))
 w(:,J)=w(:,J)+alpha*(y'-w(:,J))
 disp('v')
 disp(v)
 disp('w')
 disp(w)

//Output
// 
// After one step the weight matrix are
//
// v
//
//   0.42   0.2
//   0.72   0.2
//   0.44   0.6
//   0.14   0.6
//
// w
//
//   0.58   0.3
//   0.28   0.3
